#include "memorydc1.h"

MemoryDC::MemoryDC(HWND hwnd, COLORREF blankcol): //constructor
_hblankbrush(NULL) //Put a value in this in case you bail from the constructor early.
{
	HDC hdc;

	//To make checking for Release easier, if you need an hdc in a code
	//block, Get it in the first line and Release it in the last line.
	_cx = GetSystemMetrics(SM_CXSCREEN); //Actual size of screen
	_cy = GetSystemMetrics(SM_CYSCREEN); //measured in pixels.
	hdc = GetDC(hwnd); //MUST use a screen-derived hdc for CreateCompatible? calls.
	_hdc = CreateCompatibleDC(hdc); //Starts with area of one pixel!
	_hbitmap = CreateCompatibleBitmap(hdc, _cx, _cy);
	//Get rid of the screen-derived hdc, in case you have to bail soon.
	ReleaseDC(hwnd, hdc);
	//CreateCompatibleBitmap allocates RAM for bitmap memory, may have failed.
	if (!_hbitmap) //If there's not enough memory, tell & bail.
	{
		MessageBox( hwnd,
			(LPSTR)"Failure in Bitmap Allocation!",
			(LPSTR)"Memory Problems!",
			MB_OK | MB_ICONEXCLAMATION ); //Button flags
		SendMessage( hwnd, WM_DESTROY, 0, 0L ); //Goes to WndProc.
		return; //_hdc now has a value, and _hbitmap and _hblankbrush are NULL.
		//Presumably we'll release the _hdc inside the destructor.
	}
	//Selecting _hbitmap here makes _hdc have _CX by _CY area.
	SelectObject(_hdc, _hbitmap);
	//Create the blankbrush.
	_hblankbrush = CreateSolidBrush(blankcol);
	Clear();

}

MemoryDC::~MemoryDC() //destructor
{
	/* First Delete the device context, and then i will be safe to delete the
	GDI objects that were selected into it.  Remember the rule is that you
	can't delete a GDI tool while it is selected into a valid HDC. */
	DeleteDC(_hdc);
	/*It's possible that you never got past allocating the _hdc in constructor,
	so check the validity of the other two member handles before deleting them */
	if (_hbitmap)
		DeleteObject(_hbitmap);
	if (_hblankbrush)
		DeleteObject(_hblankbrush);
}

void MemoryDC::Clear()
{ //This clears the bitmap.
	HBRUSH callerbrush;

	//Select the blankbrush.
	callerbrush = SelectObject(_hdc, _hblankbrush);
	//This covers the screen with the selected brush pattern.
	PatBlt(_hdc, 0, 0, _cx, _cy, PATCOPY);
	//Reselect the callerbrush, in case this  matters.
	SelectObject(_hdc, callerbrush);
}

void MemoryDC::CopyTo(HDC hdc, RECT rect)
{
	BitBlt(hdc, rect.left, rect.top, //Next two arguments are width and height
		rect.right - rect.left, rect.bottom - rect.top,
		_hdc, rect.left, rect.top, SRCCOPY);
}

